% T2Rsameside (Modified Nodal Equations) using Homotopy

clear all
clc

global a

% Initial Guess

a = [1.2; 0.99 ; 7.2e-05];

% Determine a root of the homotopy function when lambda = 0

X0 = fsolve('T2Rsamesideinit',a);

% Solve the nonlinear system of equations using ODE-based homotopy,
% with a variable-order variable-step predictor-corrector integration technique

[vs,s,lambda,v,N] = pchomotopy('T2RsamesideJac',X0,2500);

% Plot the trajectory of the variables wrt lambda

plot(lambda,v)
title('Homotopy paths for T2Rsameside (Modified Nodal Equations)')
xlabel('Lambda')
ylabel('Node Voltages and Currents')
leg = legend('v(1)','v(2)','v(3)');
set(leg,'Location','NorthWest')
%axis([0 1e-6 -1 50])
grid 

% Display the final solutions of the nonlinear system of equations

%clc
disp('The final solutions for T2Rsameside (Modified Nodal Equations) are')
disp('     Sol1      ')
disp(vs)